<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Configuration extends Model
{
    // fillable
    protected $fillable = ['brand_img', 'brand_name', 'brand_logo', 'brand_mini_logo', 'brand_color', 'guide_footer', 'user_id', 'country'];

    // relations
    public function User() {
        return $this->belongsTo(User::class);
    }

    // attribues
    protected $appends = [
        'logo',
        'logoMini',
        'brandImage',
    ];

    // get attributes
    public function getLogoAttribute()
    {
        return url('images/configuration', $this->brand_logo);
    }

    public function getLogoMiniAttribute()
    {
        return url('images/configuration', $this->brand_mini_logo);
    }

    public function getBrandImageAttribute()
    {
        return url('images/configuration', $this->brand_img);
    }
}
