<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

class Domicilio extends Model
{
    use SoftDeletes;
    //fillable
    protected $fillable = ['reference', 'city_id', 'zone_id', 'payment_method_id', 'aditional_payment', 'comprobant', 'observation', 'price', 'delivery', 'total', 'status', 'domiciliario_id', 'client_id', 'type', 'invoice_url', 'log_sender_id', 'liquidated', 'content'];

    protected $appends = [
    ];

    //relations
    public function Collections()
    {
        return $this->hasMany('App\DomicilioCollection', 'domicilio_id');
    }

    public function News()
    {
        return $this->hasMany('App\DomicilioNews', 'domicilio_id');
    }

    public function Evidences()
    {
        return $this->hasMany('App\Evidence', 'domicilio_id');
    }

    public function domiciliario()
    {
        return $this->belongsTo('App\Domiciliario');
    }

    public function Products()
    {
        return $this->hasMany('App\DomicilioProduct');
    }

    public function statusDomicilio()
    {
        return $this->hasMany('App\Status');
    }

    public function Client()
    {
        return $this->belongsTo('App\Client');
    }

    // HERC
    public function logSender()
    {
        return $this->belongsTo(LogSender::class);
    }
}
