<?php

namespace App\Http\Controllers;

use App\Client;
use Illuminate\Http\Request;
use Response;
use App\Helpers\Helper;
use App\Http\Resources\Client\ClientShowResource;
use App\Http\Resources\Client\ClientFilterResource;
use App\Http\Requests\Client\PostRequest;
use App\Http\Requests\Client\PutRequest;
use App\Services\Client\ClientServices;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ClientsImport;
use App\Http\Resources\Client\ClientCollection;
use App\Traits\ApiResponser;

class ClientController extends Controller
{
    use ApiResponser;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        try {
            // saco el id principal del usuario
            $mainId = $request->user()->getIdMain($request->user());
            if ($request->user()->type == 1)
                $clients = Client::orderby('id', 'DESC')->get();
            else
                $clients = Client::Desc()->UserId($mainId)->get();
            return [
                'success' => true,
                'message' => 'Listado de clientes.',
                'data' =>  new ClientCollection($clients),
            ];
            //return Helper::response('success', new ClientCollection($clients), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    /**
     * Display a listing of the resource by user_id.
     *
     * @return \Illuminate\Http\Response
     */
    public function clientsByUserId($user_id)
    {
        try {
            $clients = Client::where('user_id', $user_id)->orderby('id', 'DESC')->get();
            return [
                'success' => true,
                'message' => 'Listado de clientes.',
                'data' =>  new ClientCollection($clients),
            ];
            //return Helper::response('success', new ClientCollection($clients), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PostRequest $request)
    {
        //
         try {
            // return $request->all();
            $mainId = $request->user()->getIdMain($request->user());
            $client = Client::create(array_merge($request->all(), ['user_id' => $mainId]));
            return Helper::response('success', ['meesage' => 'Se ha creado el cliente correctamente', 'client' => $client], 201);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Attribute  $attribute
     * @return \Illuminate\Http\Response
     */
    public function show(Client $client, ClientServices $clientServices)
    {
        //
        try {
            // $client->purse = $clientServices->loadPurse($client->id);
            $client->total = $clientServices->loadTotal($client->id);
            // $client->credit = $clientServices->credit($client->id);
            return Helper::response('success', new ClientShowResource($client), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function edit(Client $client)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(PutRequest $request, Client $client)
    {
         try {
            $mainId = $request->user()->getIdMain($request->user());
            $client->update($request->all());
            return Helper::response('success', 'Se ha creado el cliente correctamente', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function destroy(Client $client)
    {
        //delete client
        try {
            $client->delete();
            return Helper::response('success', 'Se ha eliminado el cliente correctamente', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    // create new client in our bbdd
    static function saveNewClient($client)
    {
        //
        $validateIfIsset = Client::Phone($client['phone'])->first();
        if (!isset( $validateIfIsset)) {
            $client = Client::create($client);
            return $client->id;
        }
        $validateIfIsset->fill($client);
        $validateIfIsset->save();
        return $validateIfIsset->id;
    }

    static function saveNewClient2($client, $mainId)
    {
        //
        $validateIfIsset = Client::Dni($client['dni'])->where('user_id', $mainId)->first();
        if (!isset( $validateIfIsset)) {
            $client = Client::create(array_merge($client, ['user_id' => $mainId, 'document_type_id' => 3]));
            return $client;
        }
        return $validateIfIsset;
    }

    public function filter(Request $request, $dni, ClientServices $clientServices)
    {
        //
        try {
            // saco el id principal del usuario
            $client = Client::where('dni', $dni)->first();
            if ($client) {
                $client->purse = $client->Purse;
                return Helper::response('success', $client, 200);
            } else
                return $this->errorResponse('No existe un cliente con esta cédula, se procedera a crear.', 404);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function importClients(Request $request, ClientServices $clientServices)
    {
        try {
            $mainId = $request->user()->getIdMain($request->user());
            Excel::import(new ClientsImport($mainId), $request->file('file')->store('temp'));
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

}
