<?php

namespace App\Http\Controllers;

use DB;
use App\DomicilioCollection;
use Illuminate\Http\Request;
use App\Traits\ApiResponser;
use App\Services\DomicilioCollection\DomicilioCollectionServices;
use App\Http\Requests\DomicilioCollection\DomicilioCollectionPost;

class DomicilioCollectionController extends Controller
{
    use ApiResponser;

    public $service;

    /**
     * constructor
     */
    public function __construct() {
        $this->service = new DomicilioCollectionServices();
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(DomicilioCollectionPost $request)
    {
        //
        DB::beginTransaction();
        try {
            //code...
            $collention = $this->service->createDomicilioCollection($request->all());
            DB::commit();
            return $this->successResponse([
                'success' => true,
                'message' => 'Se guardado el recaudo correctamente',
                'data' => $collention
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DomicilioCollection  $domicilioCollection
     * @return \Illuminate\Http\Response
     */
    public function show(DomicilioCollection $domicilioCollection)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DomicilioCollection  $domicilioCollection
     * @return \Illuminate\Http\Response
     */
    public function edit(DomicilioCollection $domicilioCollection)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DomicilioCollection  $domicilioCollection
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DomicilioCollection $domicilioCollection)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DomicilioCollection  $domicilioCollection
     * @return \Illuminate\Http\Response
     */
    public function destroy(DomicilioCollection $domicilioCollection)
    {
        //
    }
}
