<?php

namespace App\Http\Controllers;

use DB;
use App\DomicilioNews;
use Illuminate\Http\Request;
use App\Traits\ApiResponser;
use App\Services\DomicilioNews\DomicilioNewServices;
use App\Http\Requests\DomicilioNews\DomicilioNewsPost;

class DomicilioNewsController extends Controller
{
    use ApiResponser;

    public $service;

    /**
     * constructor
     */
    public function __construct() {
        $this->service = new DomicilioNewServices();
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(DomicilioNewsPost $request)
    {
        //
        DB::beginTransaction();
        try {
            //code...
            $news = $this->service->createDomicilioNews($request->all());
            DB::commit();
            return $this->successResponse([
                'success' => true,
                'message' => 'Se guardado la novedad correctamente.',
                'data' => $news
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DomicilioNews  $domicilioNews
     * @return \Illuminate\Http\Response
     */
    public function show(DomicilioNews $domicilioNews)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DomicilioNews  $domicilioNews
     * @return \Illuminate\Http\Response
     */
    public function edit(DomicilioNews $domicilioNews)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DomicilioNews  $domicilioNews
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DomicilioNews $domicilioNews)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DomicilioNews  $domicilioNews
     * @return \Illuminate\Http\Response
     */
    public function destroy(DomicilioNews $domicilioNews)
    {
        //
    }
}
