<?php

namespace App\Http\Controllers;

use DB;
use Carbon\Carbon;
use App\Helpers\Helper;
use App\Traits\ApiResponser;
use Illuminate\Http\Request;
use App\Services\Contability\MainServices;
use App\Http\Middleware\PermissionsMiddleware;

class MainController extends Controller
{
    use ApiResponser;

    //construct
    public $start, $end;
    protected $mainServices;

    function __construct()
    {
        $this->start = Carbon::now()->format('Y-m-d');
        $this->end = Carbon::now()->format('Y-m-d');
        $this->mainServices = new MainServices();
        $this->middleware(function ($request, $next) {
            return (new PermissionsMiddleware('home-data'))->handle($request, $next);
        })->only(['loadMainData']);
    }

    public function getSeller(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->sells($request->user(), $request->date, $request->date2, 1), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getUtilities(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->sells($request->user(), $request->date, $request->date2, 2), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getCountSell(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->sells($request->user(), $request->date, $request->date2, 3), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getPurse(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->getTotalPurse($request->user()), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function monthSells(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->monthSell($request->user()), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function countTypeSells(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->countTypeSells($request->user()), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getStorageSeller(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->getStorageSeller($request->user()), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getBestSell(Request $request) {
        try {
            return Helper::response('success', $this->mainServices->getBestSell($request->user()), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function diarySells(Request $request) {
        try {
            return $this->successResponse($this->mainServices->getDiarySells($request->user(), $request->month));
        } catch (\Exception $e) {
            $this->errorUnprocessableEntityResponse($e->getMessage());
        }
    }

    public function loadMainData(Request $request) {
        try {
            // roles
            $user = $request->user();
            // get data
            $pendiente = DB::table('domicilios')
            ->where('status', 'Pendiente')
            ->whereNull('deleted_at')
            ->when($user->role_id === 4, function($query) use($user) {
                return $query->where('log_sender_id', $user->log_sender_id);
            })
            ->count();
            $encurso = DB::table('domicilios')
            ->where('status', 'En curso')
            ->whereNull('deleted_at')
            ->when($user->role_id === 4, function($query) use($user) {
                return $query->where('log_sender_id', $user->log_sender_id);
            })
            ->count();
            $money = DB::table('domicilios')
            ->whereNull('deleted_at')
            ->when($user->role_id === 4, function($query) use($user) {
                return $query->where('log_sender_id', $user->log_sender_id);
            })
            ->select(
                DB::raw("SUM(IF(domicilios.delivery > 0, domicilios.delivery, 0) + IF(domicilios.aditional_payment > 0, domicilios.aditional_payment, 0)) as money")
            )
            ->get();
            $recaudado = DB::table('domicilios')
            ->whereNull('deleted_at')
            ->when($user->role_id === 4, function($query) use($user) {
                return $query->where('log_sender_id', $user->log_sender_id);
            })
            ->select(
                DB::raw("SUM(domicilios.total) as recaudo")
            )
            ->get();
            // prepare data
            $data['pending'] = $pendiente;
            $data['active'] = $encurso;
            $data['money'] = count($money) > 0 ? $money[0]->money  : 0;
            $data['recaudado'] = count($recaudado) > 0 ? $recaudado[0]->recaudo  : 0;
            return $this->successResponse(['success' => true, 'data' => $data]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
