<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Response;
use App\Services\Report\ReportServices;
use App\Traits\ApiResponser;

class ReportController extends Controller
{
    use ApiResponser;
    private $service;

    /**
     * Constructor
     */
    public function __construct() {
        $this->service = new ReportServices();
    }

    /**
     * global report
     */
    public function globalReport(Request $request) {
        try {
            // prepare query params
            $page = $request->page ? $request->page : 1;
            $perPage = $request->perPage ? $request->perPage : 50;
            $from = $request->from ? $request->from . ' 00:00:00' : Carbon::now()->startOfWeek()->format('Y-m-d H:s:i');
            $to = $request->to ? $request->to . ' 23:59:59' : Carbon::now()->endOfWeek()->format('Y-m-d H:s:i');
            $search = $request->search ? $request->search : '';
            $status = $request->status ? $request->status: '';
            $domiciliary = $request->domiciliario_id ? $request->domiciliario_id: '';
            $liquidated = $request->liquidated ? $request->liquidated: '';
            $city_id = $request->city_id ? $request->city_id: '';
            $zone_id = $request->zone_id ? $request->zone_id: '';
            $client_id = $request->client_id ? $request->client_id: '';
            $sender_id = $request->sender_id ? $request->sender_id: '';
            $payment_method = $request->payment_method ? $request->payment_method: '';
            // return data
            return $this->successResponse([
                'success' => true,
                'data' => $this->service->globalReport(
                    $page,
                    $perPage,
                    $from,
                    $to,
                    $search,
                    $status,
                    $domiciliary,
                    $liquidated,
                    $city_id,
                    $zone_id,
                    $client_id,
                    $sender_id,
                    $payment_method,
                ),
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
