<?php

namespace App\Http\Controllers;

use App\Status;
use App\Domicilio;
use App\Domiciliario;
use Illuminate\Http\Request;
use App\Helpers\Helper;
use App\Http\Controllers\AuditController;
use App\Http\Resources\Domicilio\DomicilioResource;
use App\Http\Resources\Domicilio\DomicilioCollection;
use Response;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Event;
use App\Events\Status\Change;
use Carbon\Carbon;

class StatusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    	//
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $mainId = $request->user()->getIdMain($request->user());
            // generamos los estados de las ordenes
            $status = Status::create([
                'status' => $request->status,
                'observation' => $request->observation,
                'domiciliario' => $request->user,
                'domicilio_id' => $request->domicilio,
            ]);
            $domiciliario = $request->domiciliario ? $request->domiciliario : null;
            $status->domicilio->update(['status' => $request->status, 'domiciliario_id' => $domiciliario]);
            if ($request->status === 3)
                $status->domicilio->update(['approve' => true, 'date_pay' => Carbon::now()->format('Y-m-d'), 'total_payment' => $status->domicilio->total, 'is_pay' => 'Si']);
            //save auditoria
            AuditController::store($request->user()->name, 'Ha modificado el estado del domicilio con la referencia: ' .$status->domicilio->reference , 'Estados', $mainId);
            $sendEmail = Event::dispatch(new Change($status));
            // preparo la data a retornar.
            $domicilios = Domicilio::Desc()->UserId($mainId)->Now();
            return Helper::response('success', ['domicilio' => new DomicilioResource($status->domicilio), 'allDomicilios' => new DomicilioCollection($domicilios)], 201);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Estados  $estados
     * @return \Illuminate\Http\Response
     */
    public function show(Estados $estados)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Estados  $estados
     * @return \Illuminate\Http\Response
     */
    public function edit(Estados $estados)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Estados  $estados
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Estados $estados)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Estados  $estados
     * @return \Illuminate\Http\Response
     */
    public function destroy(Estados $estados)
    {
        //
    }
}
