<?php

namespace App\Http\Controllers;

use App\User;
use App\Traits\ApiResponser;
use Illuminate\Http\Request;
use App\Http\Requests\User\UserRequest;
use App\Services\User\UserServices;
use App\Services\Roles\RoleServices;

class UserController extends Controller
{
    use ApiResponser;

    protected $roleServices, $userServices;

    /**
     * constructor
     */
    public function __construct(RoleServices $roleServices, UserServices $userServices) {
        $this->roleServices =  $roleServices;
        $this->userServices =  $userServices;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        try {
            $perPage = $request->perPage ? $request->perPage : 10;
            $search = $request->search ? $request->search : '';
            return $this->successResponse([
                'success' => true,
                'data' => $this->userServices->listUsers($perPage, $search),
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(UserRequest $request)
    {
        //
        try {
            $params = $request->all();
            $params['password'] = bcrypt($params['password']);
            return $this->successResponse([
                'success' => true,
                'data' => $this->userServices->createUser($params),
                'message' => 'Se ha creado el usuario correctamente.'
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(UserRequest $request, User $user)
    {
        //
        try {
            $params = $request->all();
            if ($request->has('password')) {
                $params['password'] = bcrypt($params['password']);
            }
            return $this->successResponse([
                'success' => true,
                'data' => $this->userServices->updateUser($user, $params),
                'message' => 'Se ha creado el usuario correctamente.'
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        //
        try {
            return $this->successResponse([
                'success' => true,
                'data' => $this->userServices->deleteUser($user),
                'message' => 'Se eliminado el usuario correctamente.'
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * List user roles
     * @return \Illuminate\Http\Response
     */
    public function listRoles() {
        try {
            return $this->successResponse([
                'success' => true,
                'data' => $this->roleServices->listRoles(),
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
