<?php

namespace App\Http\Requests\Configuration;

use Illuminate\Foundation\Http\FormRequest;

class SaveConfigurationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
            'brand_name' => 'required|string|max:59',
            'brand_color' => 'required|string|max:10',
            'guide_footer' => 'required|string|max:90',
            'brand_logo' => 'required|file|mimes:jpeg,png,jpg,webp|max:2048',
            'brand_mini_logo' => 'required|file|mimes:jpeg,png,jpg,webp|max:2048',
            'brand_img' => 'required|file|mimes:jpeg,png,jpg,webp|max:2048',
        ];
    }
}
