<?php

namespace App\Http\Requests\Domicilio;

use Illuminate\Foundation\Http\FormRequest;

class Comproabant extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
            'file' => 'required|max:4086|mimes:jpg,jpeg,png,bmp,tiff',
            'domicilio_id' => 'required|exists:domicilios,id'
        ];
    }

    public function messages() {
        return [
            'file.required' => 'El comprobante es requerido',
            'file.mimes' => 'Debe seleccionar solo imagenes',
            'file.max' => 'No peude exceder de 4MB el comprobante que intentas subir',
            'domicilio_id.required' => 'Selecciona el domicilio',
            'domicilio_id.exists' => 'El domicilio debe existir en nuestra base de datos'
        ];
    }
}
