<?php

namespace App\Http\Requests\Domicilio;

use App\Rules\OrderCollectionRule;
use Illuminate\Foundation\Http\FormRequest;

class OrderCreate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type' => 'required|in:Express',
            'client' => 'required',
            'client.dni' => 'required|max:15|',
            'client.phone' => 'required|max:15',
            'client.address' => 'required|max:250',
            'client.name' => 'required|max:60',
            'client.city_id' => 'required|numeric|exists:cities,id',
            'client.zone_id' => 'required|numeric|exists:zones,id',
            // 'client.email' => 'required|max:90|email',
            'sender' => 'required',
            'sender.name' => 'required|max:60',
            'sender.company' => 'required|max:60',
            'sender.phone' => 'required|max:15',
            'sender.dni' => 'required|max:15',
            'sender.email' => 'required|max:60|email',
            'sender.address' => 'required|max:60',
            'products' => 'required',
            'products.*.name' => 'required|max:90',
            'products.*.quantity' => 'required|max:90',
            'observation' => 'max:500',
            'collection' => [
                'required',
                'boolean',
                new OrderCollectionRule
            ],
            'payment_method_id' => 'required|exists:payment_methods,id'
        ];
    }

    /**
     * Mensajes
     */
    public function messages() {
        return [
            'type.in' => 'El campo type debe ser Express',
        ];
    }
}
