<?php

namespace App\Http\Resources\Client;

use Illuminate\Http\Resources\Json\ResourceCollection;

class ClientCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'name' => $models->name,
                'dni' => $models->dni,
                'phone' => $models->phone,
                'email' => $models->email,
                'address' => $models->address,
                'city_id' => $models->city_id,
                'zone_id' => $models->zone_id,
                'user_id' => $models->user_id,
            ];
        });
    }
}
