<?php

namespace App\Http\Resources\Domicilio;

use Illuminate\Http\Resources\Json\ResourceCollection;

use App\Http\Resources\Domiciliario\DomiciliarioResource;
use App\Http\Resources\DomicilioProduct\DomicilioProductsCollection;
use App\Http\Resources\Status\StatusCollection;
use App\Http\Resources\Seller\SellerResource;
use Illuminate\Support\Arr;

use Carbon\Carbon;

class DomicilioCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            if ($models->guide) {
                $has_guide = $models->guide->count() > 0 ? true : false;
            }
            if ($models->TypePayments){
                $typePayments = [];
                $Ids = [];
                foreach($models->TypePayments as $value){
                    $values = ['name' => $value->name,'amount' => $value->pivot->amount];
                    array_push($typePayments, $values);
                    array_push($Ids, $value->id);
                }
            }

            return [
                'id' => $models->id,
                'reference' => $models->reference,
                'channel' => $models->channel,
                'client_id' => $models->client_id,
                'subtotal'  => $models->subtotal,
                'observation'  => $models->observation,
                'price'  => $models->price,
                'discountTotal'  => $models->discount,
                'discount'  => $models->discount_porcent,
                'utilities'  => $models->utilities,
                'taxt'  => $models->taxt ? $models->taxt : 0,
                'tax_total'  => $models->tax_total ? $models->tax_total : 0,
                'delivery'  => $models->delivery,
                'total'  => $models->total,
                'invoice_url'  => $models->invoice_url,
                'invoice_number'  => $models->invoice_number,
                'status'  => $models->status,
                'purse' => ($models->total - $models->total_payment),
                'load_web'  => $models->load_web ? true : false,
                'is_pay'  => $models->is_pay,
                'name'  => $models->Client ? $models->Client->name : 'No posee',
                'credit'  => $models->is_credit ? 'Si' : 'No',
                'phone'  => $models->Client ? $models->Client->phone : 'No posee',
                'liquidad'  => $models->is_liquidado,
                'domiciliario'  => $models->domiciliario_id ? true : false,
                'garantia'  => $models->is_warranty,
                'seller_id'  => new SellerResource($models->Seller),
                'hora'  => $models->created_at->format('d-m-Y H:i:s'),
                'created_at'  => $models->created_at,
                'quantity'  => count($models->Products),
                'is_credit'  => $models->is_credit,
                'icg_client'  => $models->icg_client,
                'icg_document_id'  => $models->icg_document_id,
                'type'  => $models->type,
                'type_payment'  =>  $models->TypePayments ? Arr::first($Ids) : null,
                'tPayment'  => $models->TypePayments ? $typePayments: '-',
                'method_payment'  => $models->TypePayments,
                'guide' => @$has_guide ? $models->guide->id : false,
                'storage_id'  => $models->storage_id,
                'storage'  => $models->Storage,
                'returns'  => count($models->Returns),
                'date_pay' => $models->date_pay,
                'approve' => $models->approve,
                'has_guide' => @$has_guide,
                'cost_center_id' => $models->cost_center_id,
                'expiration_date' => $models->expiration_date ? $models->expiration_date : $models->created_at->format('d/m/Y'),
                'remaining' => $models->total - $models->total_payment
            ];
        });
    }
}
