<?php

namespace App\Http\Resources\Domicilio;

use Illuminate\Http\Resources\Json\ResourceCollection;

class DomicilioReportCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($models) {

            if ($models->TypePayments){
                $typePayments = [];
                $Ids = [];
                $paymetsName = '';
                foreach($models->TypePayments as $value){
                    $paymetsName .= $value->name." ";
                    $values = ['name' => $value->name,'amount' => $value->pivot->amount];
                    array_push($typePayments, $values);
                    array_push($Ids, $value->id);
                }
            }

            return [
                'id' => $models->id,
                'reference' => $models->reference,
                'channel' => $models->channel,
                'observation'  => $models->observation,
                'price'  => $models->price,
                'client_id' => $models->client_id,
                'discountTotal'  => $models->discount,
                'discount_porcent'  => $models->discount_porcent,
                'utilities'  => $models->utilities,
                'delivery'  => $models->delivery,
                'total'  => $models->total,
                'status'  => $models->status,
                'is_pay'  => $models->is_pay,
                'domiciliario'  => $models->domiciliario_id ? true : false,
                'created_at'  => $models->created_at,
                'type'  => intval($models->type),
                'type_payment'  => $models->TypePaymets,
                'method_payment'  => $models->method_payment,
                'user_id'  => $models->user_id,
                'seller_id'  => $models->seller_id,
                'seller'  => $models->Seller ? $models->Seller->name : 'Sin vendedor',
                'client_id'  => $models->client_id,
                'storage_id'  => $models->storage_id,
                'credit'  => $models->is_credit ? 'Si' : 'No',
                'is_credit'  => $models->is_credit,
                'total_payment'  => $models->total_payment != null? $models->total_payment:'0',
                'load_web'  => $models->load_web ? true : false,
                'credit_apply'  => $models->credit_apply,
                'date_pay'  => $models->date_pay,
                'approve'  => $models->approve,
                'taxt'  => $models->taxt,
                'tax_total'  => $models->tax_total,
                'invoice_url'  => $models->invoice_url,
                'invoice_number'  => $models->invoice_number,
                'remaining'  => $models->remaining,
                'subtotal'  => $models->subtotal,
                'expiration_date'  => $models->expiration_date,
                'name'  => $models->Client ? $models->Client->name : 'No posee',
                'phone'  => $models->Client ? $models->Client->phone : 'No posee',
                'tPayment'  => $models->TypePayments ? $paymetsName : '-',
                'liquidad'  => $models->is_liquidado,
                'pending' => $models->is_credit ? $models->getPending() : 0,
                'garantia'  => $models->is_warranty,
                'hora'  => $models->created_at,
                'icg_client'  => $models->icg_client,
                'icg_document_id'  => $models->icg_document_id,
                'returns'  => count($models->Returns),
                'discount'  => $models->discount,
                'subtotalWithOutTax' => $models->subtotalWithOutTax ? $models->subtotalWithOutTax : 0,
                'creditTotal' => $models->Returns ? $models->Returns->sum('total') : 0,
                'totalInvoices'=>$models->totalInvoices,
                'coste'=>$models->coste,
                'utilityTotal'=>$models->utilityTotal,
                'rentUntillity'=>$models->rentUntillity,
            ];
        });
    }
}
