<?php

namespace App\Http\Resources\PodProduct;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Http\Resources\Product\ProductsResource;
use App\ProductVariants;

class PodProductCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'reference' => $models->reference,
                'name' => $models->name,
                'price'  => $models->price,
                'utilities'  => $models->utilities,
                'product_id'  => $models->product_id,
                'total'  => $models->total,
                'subtotal'  => $models->subtotal,
                'discount'  => $models->discount,
                'selected_store'  => $models->selected_store,
                'old'  => true,
                'newProduct'  => 0,
                'quantity'  => $models->quantity,
                'product' => $models->product ? $models->product : 'Sin producto.',
                'is_devolution' => false,
                'quantity_remove' => $models->quantity >= 1 ? 1 : $models->quantity,
                'taxt' => $models->taxt,
                'tax_total' => $models->tax_total,
                'total_payment' => $models->total_payment,
                'type_payment' => $models->type_payment,
                'observation' => $models->observation,
                'seller_id' => $models->seller_id,
                'client_id' => $models->client_id,
                'user_id' => $models->user_id,
                'effecty' => $models->effecty,
                'debit' => $models->debit,
                'credit' => $models->credit,
                'transfer' => $models->transfer,
                'storage_id' => $models->storage_id,
                'is_credit' => $models->is_credit,
                'pay_total' => $models->pay_total,
                'totalDiscount' => $models->totalDiscount,
                'credit_apply' => $models->credit_apply,
                'turned' => $models->turned,
                'delivery' => $models->delivery,
                'price_general' => $models->price_general,
                'unit_of_measurement' => isset($models->product->unit_of_measurement) ? $models->product->unit_of_measurement : 'Und',
                'invoice_url' => $models->invoice_url,
                'invoice_number' => $models->invoice_number,
                'expiration_date' => $models->expiration_date,
                'open_register_id' => $models->open_register_id,
                'variant' => ProductVariants::where('sku', $models->reference)->first() ? ProductVariants::where('sku', $models->reference)->first()->attribute : ''
            ];
        });
    }
}
