<?php

namespace App\Http\Resources\Product;

use Illuminate\Http\Resources\Json\ResourceCollection;

use App\Http\Resources\Category\CategoryResource;
use App\Http\Resources\ProductVariants\ProductVariantsCollection;

class ProductsCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Ilqluminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
                return [
                    'id' => $models->id,
                    'name' => $models->name,
                    'slug' => $models->slug,
                    'type' => $models->type,
                    'status' => $models->status,
                    'description' => $models->description,
                    'short_description' => $models->short_description,
                    'featured' => $models->featured,
                    'sku' => $models->sku,
                    'cost' => $models->utilities,
                    'woocomerce_id' => $models->woocomerce_id,
                    'price' => $models->price,
                    'prices' => $models->prices,
                    'offer_price' => $models->offer_price ? $models->offer_price : 0,
                    'value' => $models->utilities,
                    'regular_price' => $models->regular_price,
                    'sale_price' => $models->sale_price,
                    'stock_quantity' => $models->storageQuantity(),
                    'stock_status' => $models->stock_status,
                    // 'category' => new CategoryResource($models->Category),
                    'variants' => new ProductVariantsCollection($models->ProductVariants),
                    'storages' => $models->getStorages(),
                    'discount' => $models->discount,
                    'soldTotal' => $this->when($models->totalSold, $models->totalSold),
                    'unit_of_measurement' => $models->unit_of_measurement,
                    'tax' => $models->tax,
                ];
            });
    }
}
