<?php

namespace App\Http\Resources\ProductVariants;

use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Http\Resources\Storage\ProductStoragePosCollection;

class ProductVariantsPosCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'storages' => new ProductStoragePosCollection($models->Storages),
                'sku' => $models->sku,
                'attribute' => $models->attribute,
                'price' => $models->price,
                'stock_quantity' => $models->stock_quantity
            ];
        });
    }
}
