<?php

namespace App\Http\Resources\Sender;

use Illuminate\Http\Resources\Json\ResourceCollection;

class SenderCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->collection->map(function ($models) {
            return [
                'id' => $models->id,
                'name' => $models->name,
                'dni' => $models->dni,
                'phone' => $models->phone,
                'email' => $models->email,
                'address' => $models->address,
                'company' => $models->company,
                'username' => $models->username
            ];
        });
    }
}
