<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LogSender extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'department',
        'city',
        'name',
        'phone',
        'section',
        'address',
        'email',
        'dni',
        'company',
        'phone',
        'order_price',
        'tax_collection',
        'discount',
        'fullfilment'
    ];

    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function Orders() {
        return $this->hasMany('App\OrderGuide', 'sender_id');
    }

    public function dispatchRelation() {
        return $this->hasMany('App\DispatchRelation', 'sender_id');
    }

    public function Domicilio() {
        return $this->hasOne(Domicilio::class, 'sender_id');
    }
}
