<?php

namespace App\Observers;

use App\City;
use App\Jobs\CitiesPropagation;
use Illuminate\Http\Request;

class CityObserver
{
    /**
     * Handle the city "created" event.
     *
     * @param  \App\City  $city
     * @return void
     */
    public function created(City $city)
    {
        //
        CitiesPropagation::dispatch($city, new Request());
    }

    /**
     * Handle the city "updated" event.
     *
     * @param  \App\City  $city
     * @return void
     */
    public function updated(City $city)
    {
        //
    }

    /**
     * Handle the city "deleted" event.
     *
     * @param  \App\City  $city
     * @return void
     */
    public function deleted(City $city)
    {
        //
    }

    /**
     * Handle the city "restored" event.
     *
     * @param  \App\City  $city
     * @return void
     */
    public function restored(City $city)
    {
        //
    }

    /**
     * Handle the city "force deleted" event.
     *
     * @param  \App\City  $city
     * @return void
     */
    public function forceDeleted(City $city)
    {
        //
    }
}
