<?php

namespace App\Observers;

use App\Status;
use App\Domicilio;
use Illuminate\Http\Request;
use App\Jobs\StatusJobPropagation;

class StatusObserver
{
    /**
     * Handle the status "created" event.
     *
     * @param  \App\Status  $status
     * @return void
     */
    public function created(Status $status)
    {
        //
        $order = Domicilio::findOrFail($status->domicilio_id);
        StatusJobPropagation::dispatch($order, new Request());
    }

    /**
     * Handle the status "updated" event.
     *
     * @param  \App\Status  $status
     * @return void
     */
    public function updated(Status $status)
    {
        //
    }

    /**
     * Handle the status "deleted" event.
     *
     * @param  \App\Status  $status
     * @return void
     */
    public function deleted(Status $status)
    {
        //
    }

    /**
     * Handle the status "restored" event.
     *
     * @param  \App\Status  $status
     * @return void
     */
    public function restored(Status $status)
    {
        //
    }

    /**
     * Handle the status "force deleted" event.
     *
     * @param  \App\Status  $status
     * @return void
     */
    public function forceDeleted(Status $status)
    {
        //
    }
}
