<?php
namespace App\Repositories;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;
use Log;

class BaseRepository
{
    protected $model, $relations;

    public function __construct(Model $model, array $relations = []) {
        $this->model = $model;
        $this->relations = $relations;
    }

    /**
     *
     * saca todos los registros
     */
    public function all($user = null) {
        $query = $this->model;
        if ($user) {
            if (!is_array($this->relations))
                return $this->model->whereHas($this->relations, function($q) use($user) {
                    $q->where('user_id', '=', $user);
                })
                ->with($this->relations)
                ->get();
            else
                return $this->model->whereHas(Arr::first($this->relations), function($q) use($user) {
                    $q->where('user_id', '=', $user);
                })
                ->with($this->relations)
                ->get();
        }
    }

    /**
     *
     * lista un registro en especifico
     * @param Model $model
     */
    public function get(Model $model) {
        return $model;
    }

    /**
     *
     * crea un registro en el modelo
     * @param Model $model
     */
    public function save(Model $model) {
        $model->save();
        return $model;
    }

    /**
     *
     * borramos un registro
     * @param Model $model
     */
    public function delete(Model $model) {
        $model->delete();
        return $model;
    }

    /**
     *
     * paginamos los registros
     */
    public function paginate($quantity) {
        return $this->model->paginate($quantity);
    }

    /**
     *
     * filter pre invoice por id
     * @param Model $model
     */
    public function filterById($id) {
        return $this->model->findOrFail($id);
    }
}
