<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    // fillable
    protected $fillable = ['name', 'description'];

    /**
     * The roles that belong to the RolePermission
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function Permissions()
    {
        return $this->belongsToMany(Permission::class, 'role_permissions', 'role_id', 'permission_id');
    }

    /**
     * Get all of the users for the Role
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function Users()
    {
        return $this->hasMany(User::class, 'role_id', 'id');
    }
}
