<?php

namespace App\Rules;

use App\Zone;
use Illuminate\Contracts\Validation\Rule;

class UniqueByZone implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        //
        $request = request();
        return !Zone::where('city_id', $request['city_id'])
        ->where('code', $request['code'])
        ->where('id', '!=', $request['id'])
        ->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Ya existe el código de zona que intentas configurar.';
    }
}
