<?php
namespace App\Services\Client;

use App\Client;
use Carbon\Carbon;
use App\Services\Domicilio\DomicilioServices;
use App\Services\Pod\PodServices;
use App\Traits\ApiResponser;
use App\DomicilioPayment;
use App\PodOrderPayments;
use App\Billing;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ClientsImport;
use Log;

/**
 *
 */
class ClientServices
{
    use ApiResponser;

	protected $domicilioServices, $podServices, $returnsServices;

	function __construct()
	{
		$this->domicilioServices = new DomicilioServices();
	}

	public function loadPurse($client) {
		$ordersPurse = $this->domicilioServices->getPurse($client);
		$podPurse = $this->podServices->getPurse($client);
		return ($ordersPurse + $podPurse);
	}

	public function loadTotal($client) {
		$ordersTotal = $this->domicilioServices->getTotalClient($client);
		$podTotal = $this->podServices->getTotalClient($client);
		return ($ordersTotal + $podTotal);
	}

	public function credit($client) {
		return $this->returnsServices->loadCreditOn($client);
	}

    /**
     *
     * set payment in order
     */
    public function setPaymentInOrder($order, $total, $user) {
        try {
            if (get_class($order) == 'App\PodOrder') {

                PodOrderPayments::create(['total' => $total, 'pod_order_id' => $order->id, 'user_id' => $order->User->id, 'is_check' => true]);
                $this->saveBilling($total, $order->Client->id, 'Pago de '.$total.', por concepto de abono al pos: '.$order->reference.', agregado por el usuario: '.$user);
            } else {
                DomicilioPayment::create(['total' => $total, 'domicilio_id' => $order->id, 'user_id' => $order->User->id, 'is_check' => true]);
                $this->saveBilling($total, $order->Client->id, 'Pago de '.$total.', por concepto de abono al pedido: '.$order->reference.', agregado por el usuario: '.$user);
            }
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     *
     * save billing
     */
    public function saveBilling($total, $client, $description) {
        try {
            Billing::create([
                'total_billing' => $total,
                'description' => $description,
                "type" => 2,
                "operator" => "-",
                "client_id" => $client
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

}
