<?php
namespace App\Services\Configuration;

use DB;
use App\Configuration;
use App\Helpers\Helper;
use App\Traits\ApiResponser;

class ConfigurationServices {
    use ApiResponser;

    /**
     * save configuration
     * @param  \Illuminate\Http\Request $params
     * @param string $userId
     */
    public function saveConfiguration($params, $userId) {
        try {
            // store data
            $configuration = Configuration::all()->first();
            if (!$configuration) {
                $configuration = Configuration::create([
                    'brand_name' => $params['brand_name'],
                    'brand_color' => $params['brand_color'],
                    'guide_footer' => $params['guide_footer'],
                    'country' => $params['country'],
                    'user_id' => $userId,
                ]);
            } else {
                $configuration->update([
                    'brand_name' => $params['brand_name'],
                    'brand_color' => $params['brand_color'],
                    'country' => $params['country'],
                ]);
            }
            // subo el logo
            if (isset($params['brand_logo']) and !is_null($params['brand_logo'])) {
                if (!is_null($configuration->brand_logo)) {
                    Helper::deleteFile($configuration->brand_logo, 'configuration');
                }
                $path = Helper::uploadImage($params['brand_logo'], 'configuration');
                $configuration->update(['brand_logo' => $path]);
            }
            sleep(1);
            // subo el logo miniatura
            if (isset($params['brand_mini_logo']) and !is_null($params['brand_mini_logo'])) {
                if (!is_null($configuration->brand_mini_logo)) {
                    Helper::deleteFile($configuration->brand_mini_logo, 'configuration');
                }
                $path = Helper::uploadImage($params['brand_mini_logo'], 'configuration');
                $configuration->update(['brand_mini_logo' => $path]);
            }
            sleep(1);
            // subo la imagen del login
            if (isset($params['brand_img']) and !is_null($params['brand_img'])) {
                if (!is_null($configuration->brand_img)) {
                    Helper::deleteFile($configuration->brand_img, 'configuration');
                }
                $path = Helper::uploadImage($params['brand_img'], 'configuration');
                $configuration->update(['brand_img' => $path]);
            }
            return $configuration;
        } catch (\Exception $e) {
            throw $e;
        }
    }

    /**
     * Get configuration
     */
    public function listConfiguration() {
        try {
            $configuration = Configuration::all()->first();
            return $configuration;
        } catch (\Exception $e) {
            throw $e;
        }
    }
}
