<?php
namespace App\Services\DomicilioCollection;

use DB;
use App\Domicilio;
use App\Helpers\Helper;
use App\DomicilioCollection;
use App\Traits\ApiResponser;
use App\Services\Domicilio\DomicilioServices;

/**
 *
 */
class DomicilioCollectionServices
{
	use ApiResponser;

    public $service;

	function __construct() {
        $this->service = new DomicilioServices();
	}

    /**
     * Create domicilio collection
     * @param array $params
     */
    public function createDomicilioCollection(array $params) {
        try {
            // valdiaremos las colecciones
            $domicilio = Domicilio::findOrFail($params['domicilio_id']);
            $data= [];
            if ($params['value'] > 0) {
                $totalCollection = $domicilio->Collections->sum('value');
                if ($domicilio->total > 0 and $totalCollection >= $domicilio->total) {
                    return $this->handlerException('Ya se ha recolectado todo el dinero del domicilio.');
                }
                $resto = $domicilio->total - $totalCollection;
                if (($totalCollection + $params['value']) > $domicilio->total) {
                    return $this->handlerException('Monto restante: ' . $resto);
                }
                // create collection
                $domicilioCollection = DomicilioCollection::create([
                    'value' => $params['value'],
                    'payment' => $params['payment'],
                    'domicilio_id' => $params['domicilio_id'],
                ]);
                $data['pending'] = $resto - $params['value'];
                if ($data['pending'] <= 0) {
                    $domicilio->update(['status' => 'Entregado']);
                    $this->service->setStatuses(array($domicilio->id), 'Entregado', '');
                }
                $data['status'] = $domicilio->status;
                $data['id'] = $domicilioCollection->id;
                $data['statuses'] = $this->service->getStatusByOrderId($domicilio->id);
            } else {
                $data['status'] = $domicilio->status;
                $data['statuses'] = $this->service->getStatusByOrderId($domicilio->id);
            }
            if (isset($params['file'])) {
                $domicilioCollection = $this->service->uploadEvidence(
                    $params['file'],
                    $params['domicilio_id'],
                    'Entrega'
                );
            }
            return $data;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
