<?php
namespace App\Services\DomicilioNews;

use DB;
use App\Domicilio;
use App\DomicilioNews;
use App\Traits\ApiResponser;
use App\Services\Domicilio\DomicilioServices;

/**
 *
 */
class DomicilioNewServices
{
	use ApiResponser;

	function __construct(){
        $this->service = new DomicilioServices();
	}

    /**
     * Create domicilio collection
     * @param array $params
     */
    public function createDomicilioNews(array $params) {
        try {
            // create news
            $domicilioCollection = DomicilioNews::create($params);
            if (isset($params['file'])) {
                $domicilioCollectionFile = $this->service->uploadEvidence(
                    $params['file'],
                    $params['domicilio_id'],
                    'Novedad'
                );
            }
            $domicilio = Domicilio::findOrFail($params['domicilio_id']);
            $domicilio->update(['status' => 'Novedad']);
            $this->service->setStatuses(
                array($params['domicilio_id']),
                'Novedad',
                $domicilioCollection->description ? $domicilioCollection->description : '',
            );
            return $domicilioCollection;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
