<?php
namespace App\Services\Report;

use DB;
use Carbon\Carbon;
use App\Traits\ApiResponser;

class ReportServices
{
    use ApiResponser;

    /**
     * global report
     * @param int $page
     * @param int $perPage
     * @param string $from
     * @param string $to
     * @param string $search
     */
    public function globalReport($page, $perPage, $from, $to, $search, $status, $domiciliary, $liquidated, $city_id, $zone_id, $client_id, $sender_id, $payment_method) {
        try {
            // set columns
            $columns = [
                'id',
                'reference',
                'status',
                'collection',
                'date',
                'hour',
                'zone',
                'city',
                'client',
                'sender',
                'domiciliary',
            ];
            // get orders
            $orders = DB::table('domicilios')
            ->leftJoin('zones', 'zones.id', '=', 'domicilios.zone_id')
            ->leftJoin('cities', 'cities.id', '=', 'domicilios.city_id')
            ->leftJoin('clients', 'clients.id', '=', 'domicilios.client_id')
            ->leftJoin('log_senders', 'log_senders.id', '=', 'domicilios.log_sender_id')
            ->leftJoin('domiciliarios', 'domiciliarios.id', '=', 'domicilios.domiciliario_id')
            ->leftJoin('payment_methods', 'payment_methods.id', '=', 'domicilios.payment_method_id')
            ->select(
                'domicilios.id as id',
                'domicilios.reference as reference',
                'domicilios.status as status',
                'domicilios.delivery as delivery',
                'domicilios.liquidated as liquidated',
                'domicilios.content as content',
                'domicilios.domiciliario_id as domiciliario_id',
                'domicilios.total as collection',
                DB::raw("DATE_FORMAT(domicilios.created_at, '%Y/%m/%d') as date"),
                DB::raw("DATE_FORMAT(domicilios.created_at, '%h:%i %p') as hour"),
                DB::raw("COALESCE(zones.name, 'No asignada') as zone"),
                DB::raw("COALESCE(cities.name, 'No asignada') as city"),
                DB::raw("COALESCE(clients.name, 'Sin cliente') as client"),
                DB::raw("COALESCE(domiciliarios.name, 'No asignado') as domiciliary"),
                DB::raw("COALESCE(payment_methods.description, 'No asignado') as payment"),
                DB::raw("COALESCE(log_senders.name, 'Sin remitente') as sender"),
            )
            ->whereBetween('domicilios.created_at', [$from, $to])
            ->when(!is_null($search), function($query) use($search, $columns) {
                $query->orHavingRaw("CONCAT_WS('', " . implode(', ', $columns) . ") LIKE '%" . $search . "%'");
            })
            ->when($status != '', function($query) use ($status) {
                return $query->where('domicilios.status', $status);
            })
            ->when($domiciliary != '', function($query) use ($domiciliary) {
                return $query->where('domicilios.domiciliario_id', $domiciliary);
            })
            ->when($liquidated != '', function($query) use ($liquidated) {
                return $query->where('domicilios.liquidated', $liquidated);
            })
            ->when($city_id != '', function($query) use ($city_id) {
                return $query->where('domicilios.city_id', $city_id);
            })
            ->when($zone_id != '', function($query) use ($zone_id) {
                return $query->where('domicilios.zone_id', $zone_id);
            })
            ->when($client_id != '', function($query) use ($client_id) {
                return $query->where('domicilios.client_id', $client_id);
            })
            ->when($sender_id != '', function($query) use ($sender_id) {
                return $query->where('domicilios.log_sender_id', $sender_id);
            })
            ->when($payment_method != '', function($query) use ($payment_method) {
                return $query->where('domicilios.payment_method_id', $payment_method);
            })
            ->whereNull('domicilios.deleted_at')
            ->groupBy('domicilios.id')
            ->paginate($perPage);
            // return data to controllers
            return [
                'orders' => $orders->items(),
                'totalPage' => $orders->total(),
            ];
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
