<?php
namespace App\Services\User;

use App\User;
use App\Traits\ApiResponser;
use App\WalletCharge;
use Illuminate\Support\Str;
use App\Http\Controllers\AuditController;
use App\OrderGuideCommission;
use App\OrderGuide;
use Log;
use DB;

class UserServices
{
    use ApiResponser;

    public function __construct() {
    }

    /**
     * Create user
     * @param array $params
     */
    public function createUser(array $params) {
        try {
            $isset = User::where('email', $params['email'])->first();
            if (isset($isset)) {
                return $this->handlerException('Existe un usuario con este correo electrónico');
            }
            $user = User::create($params);
            return $user;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * update sender user
     * @param int $senderId
     */
    public function updateUserSender($senderId, $params) {
        try {
            $user = User::where('log_sender_id', $senderId)->first();
            if ($user) {
                $user->update([
                    'email' => $params['email'],
                    'name' => $params['email']
                ]);
                if (isset($params['password']) and !is_null($params['password'])) {
                    $user->update([
                        'password' => bcrypt($params['password']),
                    ]);
                }
            }
            return $user;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * List user
     * @param int $perPage
     * @param string $search
     */
    public function listUsers(int $perPage, string $search) {
        try {
            $columns = [
                'id',
                'name',
                'email',
                'role',
                'role_id'
            ];
            $users = DB::table('users')
            ->leftJoin('roles', 'roles.id', 'users.role_id')
            ->select(
                'users.id as id',
                'users.name as name',
                'users.email as email',
                'roles.name as role',
                'roles.id as role_id'
            )
            ->when(!is_null($search), function ($query) use($search, $columns) {
                return $query->orHavingRaw("CONCAT_WS(' ', " . implode(', ', $columns) . ") LIKE '%" . $search . "%'");
            })
            ->whereNull('users.deleted_at')
            ->whereNotIn('role_id', [4, 5])
            ->paginate($perPage);
            return $users;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * filter user
     * @param int $id
     */
    public function filterById(int $id) {
        try {
            $users = DB::table('users')
            ->leftJoin('roles', 'roles.id', 'users.role_id')
            ->select(
                'users.id as id',
                'users.name as name',
                'users.email as email',
                'roles.name as role',
                'roles.id as role_id'
            )
            ->where('users.id', $id)
            ->whereNotIn('role_id', [5, 4])
            ->whereNull('users.deleted_at')
            ->first();
            return $users;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * Delete user
     * @param User $user
     */
    public function deleteUser(User $user) {
        try {
            $user->delete();
            return $user;
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }

    /**
     * Create user
     * @param array $params
     */
    public function updateUser(User $user, array $params) {
        try {
            $user->update($params);
            return $this->filterById($user->id);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
