<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->integer('id', true);
            $table->enum('type_person', ['1', '2'])->nullable();
            $table->string('name', 250)->nullable();
            $table->unsignedBigInteger('user_id')->nullable()->index('clients_user_id_foreign');
            $table->timestamps();
            $table->string('dni', 42)->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('address')->nullable();
            $table->string('department', 52)->nullable();
            $table->string('city', 52)->nullable();
            $table->string('getho')->nullable();
            $table->string('address_note')->nullable();
            $table->unsignedBigInteger('economic_activity_id')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients');
    }
}
