<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDispatchRelationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dispatch_relations', function (Blueprint $table) {
            $table->integer('id', true);
            $table->enum('status', ['En curso', 'Completada'])->nullable();
            $table->unsignedBigInteger('log_sender_id')->nullable()->index('dispatch_relations_log_sender_id_foreign');
            $table->unsignedBigInteger('domiciliario_id')->index('dispatch_relations_domiciliario_id_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dispatch_relations');
    }
}
