<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomicilioNewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domicilio_news', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('type', ['No esta en el domicilio', 'No quiere cancelar', 'Otros'])->nullable();
            $table->longText('description')->nullable();
            $table->unsignedBigInteger('domicilio_id')->nullable();
            $table->foreign(['domicilio_id'])->references(['id'])->on('domicilios')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domicilio_news');
    }
}
