<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDomicilioProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domicilio_products', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('reference')->nullable();
            $table->string('name')->nullable();
            $table->double('price', 50, 2)->nullable();
            $table->float('quantity', 50);
            $table->double('subtotal', 50, 2)->nullable();
            $table->double('discount', 50, 2)->nullable();
            $table->double('discount_porcent', 100, 2)->default(0);
            $table->double('utilities')->nullable()->default(0);
            $table->double('total', 50, 2)->nullable();
            $table->unsignedBigInteger('domicilio_id')->nullable()->index('domicilio_products_domicilio_id_foreign');
            $table->timestamps();
            $table->unsignedBigInteger('selected_store')->nullable();
            $table->unsignedBigInteger('product_variant_id')->nullable()->index('domicilio_products_product_variant_id_foreign');
            $table->unsignedBigInteger('product_id')->nullable()->index('domicilio_products_product_id_foreign');
            $table->double('tax_total', 50, 2)->nullable();
            $table->integer('taxt')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('domicilio_products');
    }
}
