<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatusesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('statuses', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('status', 250)->nullable()->default('1');
            $table->longText('observation')->nullable();
            $table->unsignedBigInteger('domicilio_id')->nullable()->index('estados_domicilio_id_foreign');
            $table->timestamps();
            $table->string('domiciliario')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('statuses');
    }
}
