<?php
namespace Database\Seeders;

use DB;
use App\Permission;
use Illuminate\Database\Seeder;

class PermissionsSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // set permission
        $permissions = [
            [
                'name' => 'List home data',
                'slug' => 'home-data',
                'description' => 'Lista dashboard card data',
            ],
            [
                'name' => 'list last orders',
                'slug' => 'last-order',
                'description' => 'Filter 10 last orders',
            ],
            [
                'name' => 'List orders',
                'slug' => 'list-orders',
                'description' => 'List orders',
            ],
            [
                'name' => 'Filter order',
                'slug' => 'filter-orders',
                'description' => 'Filter order',
            ],
            [
                'name' => 'Update order',
                'slug' => 'update-order',
                'description' => 'Update orders',
            ],
            [
                'name' => 'Delete order',
                'slug' => 'delete-order',
                'description' => 'Delete orders',
            ],
            [
                'name' => 'Create order',
                'slug' => 'create-orders',
                'description' => 'Delete orders',
            ],
            [
                'name' => 'Relation create',
                'slug' => 'relation-create',
                'description' => 'Create dispatch relation',
            ],
            [
                'name' => 'List relation',
                'slug' => 'relation-list',
                'description' => 'List dispatch relation',
            ],
            [
                'name' => 'Delete relation',
                'slug' => 'relation-delete',
                'description' => 'Delete dispatch relation',
            ],
            [
                'name' => 'Change status',
                'slug' => 'change-status',
                'description' => 'Change status in order',
            ],
            [
                'name' => 'Change status',
                'slug' => 'change-status',
                'description' => 'Change status in order',
            ],
            [
                'name' => 'List senders',
                'slug' => 'sender-list',
                'description' => 'List senders',
            ],
            [
                'name' => 'Create senders',
                'slug' => 'sender-create',
                'description' => 'Create sender',
            ],
            [
                'name' => 'Update senders',
                'slug' => 'sender-update',
                'description' => 'Update sender',
            ],
            [
                'name' => 'Delete senders',
                'slug' => 'sender-delete',
                'description' => 'Delete sender',
            ],
            [
                'name' => 'List domiciliary',
                'slug' => 'domiciliary-list',
                'description' => 'List domiciliary',
            ],
            [
                'name' => 'Create domiciliary',
                'slug' => 'domiciliary-create',
                'description' => 'Create domiciliary',
            ],
            [
                'name' => 'Update domiciliary',
                'slug' => 'domiciliary-update',
                'description' => 'Update domiciliary',
            ],
            [
                'name' => 'Delete domiciliary',
                'slug' => 'domiciliary-delete',
                'description' => 'Delete domiciliary',
            ],
            [
                'name' => 'List zones',
                'slug' => 'zone-list',
                'description' => 'List zones',
            ],
            [
                'name' => 'Create zones',
                'slug' => 'zone-create',
                'description' => 'Create zones',
            ],
            [
                'name' => 'Update zones',
                'slug' => 'zone-update',
                'description' => 'Update zones',
            ],
            [
                'name' => 'Delete zones',
                'slug' => 'zone-delete',
                'description' => 'Delete zones',
            ],
            [
                'name' => 'List cities',
                'slug' => 'city-list',
                'description' => 'List cities',
            ],
            [
                'name' => 'Create cities',
                'slug' => 'city-create',
                'description' => 'Create cities',
            ],
            [
                'name' => 'Delete cities',
                'slug' => 'city-delete',
                'description' => 'Delete cities',
            ],
            [
                'name' => 'List users',
                'slug' => 'user-list',
                'description' => 'List users',
            ],
            [
                'name' => 'Create users',
                'slug' => 'user-create',
                'description' => 'Create user',
            ],
            [
                'name' => 'Delete users',
                'slug' => 'user-delete',
                'description' => 'Delete user',
            ],
            [
                'name' => 'Update users',
                'slug' => 'user-update',
                'description' => 'Update user',
            ],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate($permission);
        }
    }
}
