<?php
namespace Database\Seeders;

use DB;
use App\Role;
use App\Permission;
use Illuminate\Database\Seeder;

class RoleSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // prepare roles
        $roles = [
            [
                'name' => 'Administrador',
                'description' => 'Administrador de la plataforma',
                'permissions' => [
                    'home-data',
                    'last-order',
                    'list-orders',
                    'create-orders',
                    'filter-orders',
                    'update-order',
                    'delete-order',
                    'relation-create',
                    'relation-list',
                    'relation-delete',
                    'change-status',
                    'sender-list',
                    'sender-create',
                    'sender-update',
                    'sender-delete',
                    'domiciliary-list',
                    'domiciliary-create',
                    'domiciliary-update',
                    'domiciliary-delete',
                    'zone-list',
                    'zone-create',
                    'zone-update',
                    'zone-delete',
                    'city-list',
                    'city-create',
                    'city-delete',
                    'user-list',
                    'user-create',
                    'user-delete',
                    'user-update'
                ]
            ],
            [
                'name' => 'Coordinador general',
                'description' => 'Coordinador general de la plataforma',
                'permissions' => [
                    'home-data',
                    'last-order',
                    'list-orders',
                    'filter-orders',
                    'create-orders',
                    'update-order',
                    'delete-order',
                    'relation-create',
                    'relation-list',
                    'relation-delete',
                    'change-status',
                    'sender-list',
                    'sender-create',
                    'sender-update',
                    'sender-delete',
                    'domiciliary-list',
                    'domiciliary-create',
                    'domiciliary-update',
                    'domiciliary-delete',
                    'zone-list',
                    'zone-create',
                    'zone-update',
                    'zone-delete',
                    'city-list',
                    'city-create',
                    'city-delete',
                    'user-list',
                    'user-create',
                    'user-delete',
                    'user-update'
                ]
            ],
            [
                'name' => 'Coordinador regional',
                'description' => 'Coordinador regional de la plataforma',
                'permissions' => [
                    'home-data',
                    'last-order',
                    'list-orders',
                    'create-orders',
                    'filter-orders',
                    'update-order',
                    'delete-order',
                    'relation-create',
                    'relation-list',
                    'relation-delete',
                    'change-status',
                    'sender-list',
                    'sender-create',
                    'sender-update',
                    'sender-delete',
                    'domiciliary-list',
                    'domiciliary-create',
                    'domiciliary-update',
                    'domiciliary-delete',
                    'zone-list',
                    'zone-create',
                    'zone-update',
                    'zone-delete',
                    'city-list',
                    'city-create',
                    'city-delete'
                ]
            ],
            [
                'name' => 'Coordinador regional',
                'description' => 'Coordinador regional de la plataforma',
                'permissions' => [
                    'home-data',
                    'last-order',
                    'create-orders',
                    'filter-orders',
                    'update-order',
                    'delete-order',
                    'relation-create',
                    'relation-list',
                    'relation-delete',
                    'change-status',
                    'sender-list',
                    'sender-create',
                    'sender-update',
                    'sender-delete',
                    'domiciliary-list',
                    'domiciliary-create',
                    'domiciliary-update',
                    'domiciliary-delete',
                    'zone-list',
                    'zone-create',
                    'zone-update',
                    'zone-delete',
                    'city-list',
                    'city-create',
                    'city-delete'
                ]
            ],
            [
                'name' => 'Remitente',
                'description' => 'Remitente de la plataforma',
                'permissions' => [
                    'home-data',
                    'last-order',
                    'create-orders',
                    'delete-order',
                    'list-orders',
                    'last-orders',
                    'filter-orders',
                    'update-order',
                    'change-status',
                    'domiciliary-list',
                    'city-list',
                    'zone-list',
                    'sender-list'
                ]
            ],
            [
                'name' => 'Domiciliario',
                'description' => 'Domiciliario de la plataforma',
                'permissions' => [
                    'list-orders',
                    'filter-orders',
                    'update-order',
                    'change-status',
                    'domiciliary-update',
                ]
            ],
        ];

        // create data
        foreach ($roles as $roleData) {
            $role = Role::firstOrCreate([
                'name' => $roleData['name'],
                'description' => $roleData['description'],
            ]);
            foreach ($roleData['permissions'] as $permissionSlug) {
                $permission = Permission::firstWhere('slug', $permissionSlug);

                if ($permission) {
                    $role->Permissions()->syncWithoutDetaching([$permission->id]);
                }
            }
        }
    }
}
