<?php

use App\Http\Resources\Product\InventoryMovementsCollection;
use Doctrine\DBAL\Schema\Index;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

//api version 2
Route::group(['prefix' => 'v2'], function () {
    // download excel
    Route::get('/download/excel','DomicilioController@exportExcel');
    Route::get('/download/cities/excel','CityController@exportExcel');
    Route::get('/download/zones/excel','ZoneController@exportExcel');

    // auth routes with out api middleware
    Route::post('login', 'AuthController@login');
    Route::post('recovery', 'AuthController@recovery');
    Route::post('change/password', 'AuthController@changePasswordForToken');
    Route::get('cities/list', 'CityController@listCities');

    // orders api external
    Route::group(['middleware' => 'dropiService'], function () {
        Route::post('order/create', 'DomicilioController@createOrder'); // create order
        Route::get('list/payments', 'PaymentController@index'); // get payment methods
        Route::get('list/cities', 'CityController@listCities'); // List cities
        Route::get('list/zones', 'ZoneController@listZonesByCity'); // List zones
        Route::get('print/sticker', 'DomicilioController@generateGuide'); // generate sticker
        Route::delete('order/cancel/{reference}', 'DomicilioController@cancelOrder');  // cancela una orden generada
        Route::get('order/details/{reference}', 'DomicilioController@showOrderDetails'); // get order data.
    });

    Route::group(['middleware' => ['auth:api', 'isActive']], function () {
        // auth
        Route::post('logout', 'AuthController@logout');
        // clients
        Route::resource('client', 'ClientController');
        Route::get('clients-by-dni/{dni}', 'ClientController@filter');
        Route::get('clients-by-user/{user_id}', 'ClientController@clientsByUserId');
        //payment request
        Route::get('load-payment', 'PaymentController@index');
        // Raul
        Route::get('domiciliario/search', 'DomiciliarioController@search');
        Route::resource('domiciliario', 'DomiciliarioController');
        //auditorias routes
        Route::resource('auditorias', 'AuditController');
        //domicilios ->middleware("plan")
        Route::resource('domicilio', 'DomicilioController');
        Route::post('/domicilio/update', 'DomicilioController@update');
        Route::post('domicilio/update-domiciliary', 'DomicilioController@updateDomiciliary');
        Route::get('/domicilios/filter', 'DomicilioController@orderTimeInterval');
        Route::post('/domicilio/factura', 'DomicilioController@generatePdf');
        Route::post('/domicilios/status-paid', 'DomicilioController@changeStatusPaid');
        Route::post('/domicilio/delete', 'DomicilioController@destroy');
        Route::get('/domicilioget', 'DomicilioController@getAll');
        Route::get('/domicilioget/{id}', 'DomicilioController@getOne');
        Route::post('/bulk-status/domicilios', 'DomicilioController@changeStatusInbulk');
        Route::post('/domicilio/filter-date', 'DomicilioController@filterDateRange');
        Route::get('/domicilio-history/getAll', 'DomicilioController@getHistory');
        Route::get('/domicilio/reference/{id}', 'DomicilioController@getByReference')->name('domicilio.reference');
        Route::get('/getLastOrders', 'DomicilioController@getLastOrders');
        Route::get('generate/guide', 'DomicilioController@generateGuide');
        Route::post('domicilio/from/excel', 'DomicilioController@importFromExcel');
        //estados
        Route::resource('status', 'StatusController');
        //liquidar
        Route::post('/domicilio/liquidar', 'DomicilioController@liquidarPdf');
        // reports
        Route::get('report/global', 'ReportController@globalReport');
        // logistica-remitentes
        Route::get('logistica-remitente', 'LogisticaRemitenteController@index');
        Route::get('logistica-remitente/{id}', 'LogisticaRemitenteController@show');
        Route::post('logistica-remitente', 'LogisticaRemitenteController@store');
        Route::put('logistica-remitente/{id}', 'LogisticaRemitenteController@update');
        Route::delete('logistica-remitente/{id}', 'LogisticaRemitenteController@destroy');
        Route::get('remitentes-for-select', 'LogisticaRemitenteController@getForSelect');
        // Ciudad
        Route::get('city', 'CityController@index');
        // -------------------------------------------------------------------------
        // main routes //-----------------------------------------------------------
        Route::get('main/data', 'MainController@loadMainData');
        // relation dispatch
        Route::resource('dispatchRelation', 'DispatchRelationController');
        Route::get('genearet-relation-pdf', 'DispatchRelationController@emitPdf');
        Route::get('relation/today', 'DispatchRelationController@getTodayRelation');
        Route::get('/relation/list/domiciliario', 'DispatchRelationController@listByDomiciliario');
        Route::get('orders/by/domiciliario', 'DispatchRelationController@loadOrderByRelationOrNot');
        Route::get('orders/show/{id}', 'DispatchRelationController@getOrderById');
        Route::get('relation/complete/{id}', 'DispatchRelationController@completeRelation');
        // domicilio collection
        Route::resource('domicilioCollection', 'DomicilioCollectionController');
        // domicilio news
        Route::resource('domicilioNews', 'DomicilioNewsController');
        // evidence
        Route::post('comprobant-upload', 'DomicilioController@uploadEvidence');
        // cities
        Route::resource('city', 'CityController');
        // zones
        Route::resource('zone', 'ZoneController');
        // senders
        Route::resource('sender', 'LogisticaRemitenteController');
        Route::get('forSelect/sender', 'LogisticaRemitenteController@getForSelect');
        // users
        Route::resource('user', 'UserController');
        /**
         * general routes
         */
        Route::group(['prefix' => 'general'], function () {
            Route::get('departaments', 'GeneralController@getDepartaments');
            Route::get('roles', 'UserController@listRoles');
            Route::resource('configuration', 'ConfigurationController');
        });
    });
    // configuration with out auth
    Route::get('configuration', 'ConfigurationController@index');
});
