<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Audit extends Model
{
    //fillable
    protected $fillable = ['user', 'observation', 'entity', 'date', 'hour', 'user_id', 'name'];

    //hook
    public static function getAuditoriasByUserType($user) {
        if ($user->type == 1)
            $audit = Audit::orderBy('id', 'DESC')
            ->get();

        if ($user->type == 2)
            $audit = Audit::orderBy('id', 'DESC')
            ->where('user_id', '=', $user->id)
            ->get();

         if ($user->type == 4)
            $audit = Audit::orderBy('id', 'DESC')
            ->where('user_id', '=', $user->parent_id)
            ->get();

        if ($user->type == 5)
            $audit = Audit::orderBy('id', 'DESC')
            ->where('user_id', '=', $user->parent_id)
            ->get();

        return $audit;
    }

}
