<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    //fillable
    protected $fillable = [
        'name',
        'abbreviation',
        'departament_id',
        'country'
    ];

    // relations
    public function Departament()
    {
        return $this->belongsTo('App\Departament');
    }

    public function Clients()
    {
        return $this->hasMany('App\Client', 'city_id');
    }

    public function domiciliarios()
    {
        return $this->belongsToMany(
            Domiciliario::class,
            'domiciliario_has_cities',
            'city_id',
            'domiciliario_id'
        );
    }
}
