<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class ExecuteDailyReport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'report:daily';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Ejecuta el endpoint para generar el reporte diario';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Define la URL del endpoint
        $url = env("APP_URL") . '/api/v2/report/daily';

        try {
            // Realiza la petición GET
            $response = Http::get($url);

            if ($response->successful()) {
                $this->info('Reporte diario ejecutado con éxito.');
                $this->line($response->body());
            } else {
                $this->error('Error al ejecutar el reporte diario.');
                $this->error('Código de respuesta: ' . $response->status());
                $this->line($response->body());
            }
        } catch (\Exception $e) {
            $this->error('Error al conectarse al endpoint: ' . $e->getMessage());
        }

        return 0;
    }
}
