<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DispatchRelation extends Model
{
    protected $fillable = [
        'status',
        'log_sender_id',
        'domiciliario_id',
        'is_open'
    ];


    public function logSender()
    {
        return $this->belongsTo(LogSender::class);
    }

    public function domiciliario()
    {
        return $this->belongsTo(Domiciliario::class);
    }

    public function dispatchRelationItems()
    {
        return $this->hasMany(DispatchRelationItem::class);
    }
}
