<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Domiciliario extends Model
{
    use SoftDeletes;

    //fillable
    protected $fillable = [
        'name',
        'email',
        'dni',
        'phone',
        'placa',
        'photo',
        'username',
        'password',
        'user_id',
        'hiring_method'
    ];

    //relations

    public function domicilios()
    {
        return $this->hasMany('App\Domicilio');
    }

    public function dispatchRelation()
    {
        return $this->hasMany('App\DispatchRelation', 'domiciliario_id');
    }

    public function User()
    {
        return $this->belongsTo('App\User');
    }

    // scope
    public function scopeDesc($query)
    {
        return $query->orderBy('id', 'DESC');
    }

    public function scopeAsc($query)
    {
        return $query->orderBy('id', 'ASC');
    }

    public function scopeUserId($query, $id)
    {
        return $query->where('user_id', $id);
    }

    public function cities()
    {
        return $this->belongsToMany(
            City::class,
            'domiciliario_has_cities',
            'domiciliario_id',
            'city_id'
        );
    }
}
