<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DomiciliosRescheduling extends Model
{
    use SoftDeletes;

    protected $fillable = [
        "domicilio_id",
        "rescheduling_date",
        "rescheduling_start_hour",
        "rescheduling_end_hour",
        "description",
        "evidence_id"
    ];

    public function domicilio()
    {
        return $this->belongsTo(Domicilio::class);
    }

    public function evidence()
    {
        return $this->belongsTo(Evidence::class);
    }
}
