<?php

namespace App\Exports;

use DB;
use App\Domicilio;
use App\LogSender;
use App\Domiciliario;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;
use PhpOffice\PhpSpreadsheet\NamedRange;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class DomicilioExcel implements FromCollection, WithHeadings, WithEvents, WithStrictNullComparison, ShouldAutoSize
{
    public $type, $senders, $domiciliarys, $paymentMethods;

    /**
     * constructor
     */
    public function __construct() {
        $this->type = ['Domicilio', 'Producto'];
        $this->senders = LogSender::get()->pluck('name')->toArray();
        $this->domiciliarys = Domiciliario::get()->pluck('name')->toArray();
        $this->paymentMethods = DB::table('payment_methods')->pluck('description')->toArray();
    }

    /**
     * Set header of domicilio excell
     *
     * @return response()
     */
    public function headings(): array {
        $header = [
            'Pos',
            'type',
            'Remitente',
            'Domiciliario',
            'Costo domicilio',
            'Recaudo',
            'Metodo de pago',
            'Destinatario',
            'Identificación',
            'Dirección',
            'Ciudad',
            'Zona',
            'Teléfono',
            'Observación',
            'Producto',
            'Sku',
            'Cantidad',
            'Precio',
        ];
        return $header;
    }

    /**
     * Llenamos la data si tenemos data
     */
    public function collection()
    {
        // Obtener la colección de datos que deseas exportar
        return collect([]);
    }

    /**
     * Preload data dinamically
     */
    public function registerEvents(): array {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $event = $this->configureOptions($event, $this->type, 'B');
                $event = $this->configureOptions($event, $this->paymentMethods, 'G');
            }
        ];
    }

    /**
     * configure options
     */
    public function configureOptions($event, $options, $letter) {
        // Definir el rango con nombre
        $nombreRango = "Lista {$letter}";
        $worksheet = $event->sheet->getDelegate();
        $event->sheet->getParent()->addNamedRange(new NamedRange($nombreRango, $worksheet, "{$letter}$1:{$letter}$".(count($options)), true));
        // Configuración de validación para la primera celda
        $firstCellValidation = $event->sheet->getCell("{$letter}2")->getDataValidation();
        $firstCellValidation->setType(DataValidation::TYPE_LIST);
        $firstCellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
        $firstCellValidation->setAllowBlank(false);
        $firstCellValidation->setShowInputMessage(true);
        $firstCellValidation->setShowErrorMessage(true);
        $firstCellValidation->setShowDropDown(true);
        \Log::debug(sprintf('"%s"', implode(',', $options)));
        $firstCellValidation->setFormula1(sprintf('"%s"', implode(',', $options)));
        // Aplicar validación a la primera celda
        $event->sheet->getCell("{$letter}2")->setDataValidation(clone $firstCellValidation);
        // Aplicar validación a las celdas restantes
        for ($i = 3; $i <= 100; $i++) {
            $currentCell = $event->sheet->getCell("{$letter}{$i}");
            $currentCell->setDataValidation(clone $firstCellValidation);
        }
        return $event;
    }
}
