<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Services\User\UserServices;
use App\Traits\ApiResponser;
use Illuminate\Http\Request;

use App\Services\Domicilio\DomicilioServices;
use App\Domicilio;
use Illuminate\Support\Facades\DB;

class AsignarController extends Controller
{
    use ApiResponser;
    public $userService, $domicilioService;


    public function __construct(DomicilioServices $domicilioService)
    {
        $this->userService = new UserServices();
        $this->domicilioService = $domicilioService;
    }
    public function assignDomiciliary(Request $request)
    {
        DB::beginTransaction();
        try {
            $mainId = $request->user()->getIdMain($request->user());
            $domicilio = $this->domicilioService->assignDomiciliary($request->all());
            DB::commit();
            return Helper::response('success', $domicilio, 200);
        } catch (\Exception $e) {
            DB::rollback();
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function assignDomiciliaryApk(Request $request)
    {
        DB::beginTransaction();
        try {
            $mainId = $request->user()->getIdMain($request->user());
            $domicilio = $this->domicilioService->assignDomiciliaryApk($request->all());
            DB::commit();
            return Helper::response('success', "Se te ha asignado la orden de manera exitosa", 200);
        } catch (\Exception $e) {
            DB::rollback();
            return Helper::response('error', $e->getMessage(), 400);
        }
    }
}
