<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Traits\ApiResponser;
use App\Services\DomicilioNews\DomicilioNewServices;
use App\Http\Requests\DomicilioNews\DomicilioNewsPost;

class DomicilioNewsController extends Controller
{
    use ApiResponser;

    public $service;

    /**
     * constructor
     */
    public function __construct(DomicilioNewServices $domicilioNewServices)
    {
        $this->service = $domicilioNewServices;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(DomicilioNewsPost $request)
    {
        //
        DB::beginTransaction();
        try {
            //code...
            $news = $this->service->createDomicilioNews($request->all());
            DB::commit();
            return $this->successResponse([
                'success' => true,
                'message' => 'Se guardado la novedad correctamente.',
                'data' => $news
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return $this->handlerException($e->getMessage());
        }
    }

    public function getDomiciliosNewByDomicilio(Request $request)
    {
        try {
            $domicilioNew = $this->service->getDomicilioNewById($request->id);
            return $this->successResponse([
                "success" => true,
                "message" => "Se obtuvo la novedad correctamente.",
                "data" => $domicilioNew
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage());
        }
    }
}
