<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Http\Requests\Rescheduling\StoreReschedulingRequest;
use App\Services\Rescheduling\ReschedulingService;
use App\Traits\ApiResponser;
use Illuminate\Support\Facades\DB;
use App\Enums\DomicilioStatusConst;
use App\Http\Requests\Domicilio\SolveDomicilioRequest;

class DomiciliosReschedulingController extends Controller
{
    use ApiResponser;

    protected $domicilioService;
    protected $reschedulingService;

    public function __construct(ReschedulingService $reschedulingService)
    {
        $this->reschedulingService = $reschedulingService;
    }

    public function store(StoreReschedulingRequest $request)
    {
        DB::beginTransaction();
        try {
            $observation = $request->observation ?? '';
            $rescheduling = $this->reschedulingService->setStatuses(
                $request->domicilio_id,
                DomicilioStatusConst::RESCHEDULED,
                $request->description,
                $request->date,
                $request->startTime,
                $request->endTime,
                $request->file
            );
            DB::commit();

            return $this->successResponse([
                'success' => true,
                'message' => 'Se reprogramo el domicilio y se guardado la novedad correctamente.',
                'data' => $rescheduling
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function solvingOrder(SolveDomicilioRequest $request, $reference)
    {
        try {
            $body = $request->all();
            $order = $this->reschedulingService->solveDomicilio($reference, $body);

            $message = "";
            if ($order->status === DomicilioStatusConst::RESCHEDULED) {
                $message = "Se genero solucion para la orden $reference";
            } else {
                $message = "Se cancelo la orden $reference";
            }

            return $this->successResponse([
                'success' => true,
                'message' => $message,
                'data' => $order
            ]);
        } catch (\Exception $e) {
            return $this->handlerException($e->getMessage(), 400);
        }
    }
}
