<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\NewTypes\NewTypesService;
use App\Helpers\Helper;
use App\NewType;
use App\Http\Resources\NewTypes\NewTypeResource;
use App\Http\Requests\NewTypes\NewTypeRequest;
use App\Http\Requests\NewTypes\UpdateNewTypeRequest;

class NewTypeController extends Controller
{
    protected $newTypesService;

    public function __construct(NewTypesService $newTypesService)
    {
        $this->newTypesService = $newTypesService;
    }

    public function index(Request $request)
    {
        try {
            $perPage = $request->perPage ? $request->perPage : 10;
            $search = $request->search ? $request->search : '';

            return $this->newTypesService->getAllNewTypesPaginated($perPage, $search);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function getAllList()
    {
        try {
            return $this->newTypesService->getAllNewTypes();
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function store(NewTypeRequest $request)
    {
        try {
            $name = $request->input("name");
            $newType = $this->newTypesService->create($name);
            return Helper::response(
                'success',
                [
                    'meesage' => 'Se ha registrado el tipo de novedad',
                    'new' => $newType
                ],
                201
            );
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }


    public function show(NewType $newType)
    {
        try {
            return Helper::response('success', new NewTypeResource($newType), 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function update(UpdateNewTypeRequest $request, NewType $newType)
    {
        try {
            $name = $request->input("name");
            $this->newTypesService->update($newType, $name);
            return Helper::response('success', 'Se ha editado el tipo de novedad', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }

    public function destroy(NewType $newType)
    {
        try {
            $newType->delete();
            return Helper::response('success', 'Se ha eliminado el tipo de novedad', 200);
        } catch (\Exception $e) {
            return Helper::response('error', $e->getMessage(), 400);
        }
    }
}
